<?php
//	http://localhost:81/psp/kara1/home
//  http://s.piearson.shop/psp/kara1/home

//	ALTER TABLE `room_info` ADD `status` TINYINT NOT NULL DEFAULT '0' AFTER `OrderNo`;

// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');

class Kara1Controller extends AppController {
	public $name = 'Kara1';
	public $uses = array('RoomGroup', 'RoomInfo', 'Staff', 'RatePlan', 'DiscountPremium', 'SalesSlip', 'MemberList', 'CheckDT1');
		//array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
		//				 'CartDT7', 'CartORD', 'Config', 'TopMenu',
		//					'CheckDT1Old', 'CartDT7Old', 'CartORDOld');
	public $layout = 'kara1';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;
	public $_server_name =  "";
	public $_server_name2 =  "";

	public $_up_date = "";

	public $_check_id = "";
	public $_room_id = 0;
	public $_kind = "";
	public $_error_msg = "";
	public $_rate_plan_id = 0;
	public $_enter_room_time ="";
	public $_leave_room_time ="";
	public $_available_time ="";
	
	public $_staff_id = 0;
	
	public $_general = 0;
	public $_member = 0;
	public $_member2 = 0;
	public $_free = 0;
	public $_people = 0;
	public $_male = 0;
	public $_female = 0;
	public $_children = 0;

	public $_member_id = 0;
	public $_grade_id = 0;
	 
	public $_room_charge = 0;
	public $_sales = 0;
	public $_discount_id = 0;
	public $_discount = 0;
	public $_premium_id = 0;
	public $_premium = 0;
	public $_other = 0;
	public $_tax = 0;
	public $_total = 0;
	public $_avance_payment	= 0;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "http://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->_server_name = substr($_SERVER['SERVER_NAME'], 0, 2);
		if($this->_server_name == "s.")
			$this->_server_name = "s";
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "から次郎".$this->_server_name2;
		$this->set('main_title', $main_title);

	}

	public function index(){
		$this->redirect(array('controller' => 'kara1', 'action' => 'enter_room'));
	}

	public function enter_room($cmd=0, $arg1=0, $staff_id=0){
		$main_title = "入室処理".$this->_server_name2;
		$this->set('main_title', $main_title);

		if($cmd>0){
			GetSessionData();
		}
		$error_msg = "";
		if($cmd==0){
			if($arg1==0 or $staff_id==0){
				$error_msg = "室番号or担当番号エラー";
			}else{
				$this->_room_id = $arg1;
				$this->_staff_id = $staff_id;
				$this->_check_id = dechex(strtotime('now').sprintf('%02d', $arg1).sprintf('%02d', $staff_id));

				$save_array = array('id' => NULL, 'check_id'=>$this->_check_id, 'room_no'=>$this->_room_id, 'up_date'=>date("Y-m-d H:i:s"));
				$ret = $this->CheckDT1->save($save_array);

				session_start();
				//unset($_SESSION['check_id']);//セッション変数の削除
				$_SESSION['check_id'] = $this->_check_id;//変数をセッションに登録
				//echo $_SESSION['check_id'];//セッションを読み込み変数を呼び出す
			}
		
		}elseif($cmd==1){		//決定
			$this->GetSessionData();
			$this->SetPublicData();

		}elseif($cmd==2){		//料金・変更
			$this->GetSessionData();
//debug($dt);
//debug($this->_room_id);
//debug($this->_staff_id);

		}elseif($cmd==2.1){		//料金・変更
			$this->SetPublicData();
//debug($this->request->data);
			$this->_rate_plan_id = $arg1;//料金・変更
			$this->Common->SaveFieldModel("CheckDT1", $this->_check_id, "unit_price_kind", (int)$this->_rate_plan_id);

debug($this->_rate_plan_id);
			$cmd = 0;

		}elseif($cmd >=3 and $cmd <3.9){		//値引き割増処理
			$cmd = $this->CMD3Proc($cmd, $arg1);

		}elseif($cmd >=5){		//値引き割増処理
			$this->GetSessionData();
			$this->SetPublicData();
			$data = $this->request->data;
			if(isset($data['check_id'])){
//debug($this->request->data);
				$this->Common->SaveFieldModel("SalesSlip", $data['check_id'], "enter_room_time", $data['time1']);
				$cmd = 0;
			}
		}elseif($cmd==21){		//人数 入力後
			$this->GetSessionData();
			$this->SetPublicData();
//debug($this->_room_id);		
//debug($this->_staff_id);		
//debug($this->request->data);
//exit();
			$data = $this->request->data;
			if(isset($data['people_kind'])){	//'people_kind' => '1',
				if($data['people_kind'] == 0)	//一般
					$field = "general";
				elseif($data['people_kind'] == 1)	//会員
					$field = "people";
				elseif($data['people_kind'] == 2)	//学生・シニア
					$field = "people2";
				elseif($data['people_kind'] == 3)	//無料
					$field = "free";

				elseif($data['people_kind'] == 7)	//男性
					$field = "male";
				elseif($data['people_kind'] == 8)	//女性
					$field = "female";
				elseif($data['people_kind'] == 9)	//子供
					$field = "children";
				else{
debug("不明種類：".$data['people_kind']);
				}
				

				$id = $this->SalesSlip->field('id', array('check_id'=>$data['check_id']), 'id DESC');
				if($id > 0){
					$this->SalesSlip->updateAll(array($field=>$data['people_qty']), array('id'=>$id));
				}else{
					$save_array = array('id'=>NULL, $field=>$data['people_qty'], 'check_id'=>$data['check_id']);
					$this->SalesSlip->save($save_array);
					$id = $this->SalesSlip->field('id', array('check_id'=>$data['check_id']), 'id DESC');
				}
				$people = $this->SalesSlip->field('male', array('check_id'=>$data['check_id']), 'id DESC');
				$people += $this->SalesSlip->field('female', array('check_id'=>$data['check_id']), 'id DESC');
				$people += $this->SalesSlip->field('children', array('check_id'=>$data['check_id']), 'id DESC');
				$this->SalesSlip->updateAll(array('people'=>$people), array('id'=>$id));
				$cmd=0;

			}

		}

		$this->SetPublicData();
//debug($this->_room_id);		
//debug($this->_staff_id);		
		if($this->_check_id != ""){
			$conditions = array('check_id'=>$this->_check_id);
			$order = array('id' => 'DESC');	//ASC | DESC
			$sales_slip = $this->SalesSlip->find('first', array('conditions' => $conditions, 'order' => $order));
//debug($sales_slip);
			if(isset($sales_slip['SalesSlip']))
				$id = $sales_slip['SalesSlip']['id'];
			else
				$id = NULL;
			$save_array = array('id'=>$id, 'room_id'=>$this->_room_id, 'check_id'=>$this->_check_id,
					'rate_plan_id'=>$this->_rate_plan_id , 'enter_room_time'=>$this->_enter_room_time,
					'leave_room_time'=>$this->_leave_room_time, 'available_time'=>$this->_available_time,
					'staff_id'=>$this->_staff_id, 'general'=>$this->_general, 'member'=>$this->_member,
					'member2'=>$this->_member2, 'free'=>$this->_free, 'people'=>$this->_people, 'male'=>$this->_male,
					'female'=>$this->_female,'children'=>$this->_children,'member_id'=>$this->_member_id,
					'grade_id'=>$this->_grade_id, 'room_charge'=>$this->_room_charge, 'sales'=>$this->_sales,
					'discount_id'=>$this->_discount_id, 'discount'=>$this->_discount,
					'premium_id'=>$this->_premium_id, 'premium'=>$this->_premium,
					'other'=>$this->_other, 'tax'=>$this->_tax, 'total'=>$this->_total, 
					'avance_payment'=>$this->_avance_payment,
					'up_date'=>date("Y-m-d H:i:s"));
			$this->SalesSlip->save($save_array);
		}

		if($this->_room_id > 0 and $this->_staff_id > 0){
			$conditions = array('id'=>$this->_room_id);
			$order = array('id' => 'DESC');	//ASC | DESC
			$rooms = $this->RoomInfo->find('first', array('conditions' => $conditions, 'order' => $order));
			$this->set('rooms', $rooms['RoomInfo']);

			$conditions = array('id'=>$this->_staff_id);
			$staffs = $this->Staff->find('first', array('conditions'=>$conditions));
			$this->set('staffs', $staffs['Staff']);
		}

		$rate_plans = $this->RatePlan->find('all', array('order' => array('id' => 'ASC')));
		$this->set('rate_plans', $rate_plans);
		
		$conditions = array('mode'=>1);
		$discounts = $this->DiscountPremium->find('all', array('conditions'=>$conditions, 'order' => array('id' => 'ASC')));
		$this->set('discounts', $discounts);
		
		$discount_premiums = array("値引設定", "割増設定", "値引データ一覧", "割増データ一覧", "値引削除", "割増削除");
		$this->set('discount_premiums', $discount_premiums);

		$peoples = array("一般", "会員", "学生･ｼﾆｱ", "無料", "", "", "利用人数", "男性", "女性", "子供", "", "");
		$this->set('peoples', $peoples);

		if(isset($sales_slip['SalesSlip'])){
			$ss = $sales_slip['SalesSlip'];
			$qtys = array($ss['general'], $ss['member'], $ss['member2'], $ss['free'], 0, 0, 
					$ss['people'], $ss['male'], $ss['female'], $ss['children'], 0, 0);
		}else{
			$qtys = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		}
		$this->set('qtys', $qtys);


		$members = array("会員番号", "氏　名", "メモ", "会員グレード", "生年月日", "有効期限", "来店回数", 
							"最終来店日", "ポイント", "テーブル1", "テーブル2", "テーブル3");
		$this->set('members', $members);
		
		//MemberList

		$sales_items = array("室　料", "販　売", "値　引", "割　増", "その他", "", "", 
							"", "消費税", "合　計", "前受金");
		$this->set('sales_items', $sales_items);
		
		$tax = 0;
		$total = 0;
		if(isset($sales_slip['SalesSlip'])){
			$ss = $sales_slip['SalesSlip'];
			$sales_slips = array($ss['room_charge'], $ss['sales'], $ss['discount'], $ss['premium'], $ss['other'],
					"　", "　", "　", $tax, $total, $ss['avance_payment']);
		}else{
			$sales_slips = array(0, 0, 0, 0, 0,   "　", "　", "　", 0, 0,  0);
		}
		$this->set('sales_slips', $sales_slips);

		$this->set('error_msg', $error_msg);
		$this->set('cmd', $cmd);
		$this->MakeHidden();
	}



	private function CMD3Proc($cmd, $arg1){
		if($cmd==3){		//値引き割増処理
			$this->GetSessionData();
		}elseif($cmd==3.1){		//値引き割増処理 post
			$this->GetSessionData();
			$this->SetPublicData();
			if(isset($this->request->data['discount_premium'])){
				$dp = $this->request->data['discount_premium'];
				$this->redirect(array('controller' => 'kara1', 'action' => 'enter_room', "3.11", $dp));
			}
			$cmd=0;
		}elseif($cmd==3.11){		//値引き理由
			$this->GetSessionData();
			$this->SetPublicData();
//debug($arg1);
//debug($this->request->data);
//exit();
			$this->set('cmd3_11', $arg1);
		}elseif($cmd==3.12){		//値引き理由
			$discount_premium_i = $arg1;
			$this->set('discount_premium_i', $discount_premium_i);

		}elseif($cmd==3.13){		//値引き理由 入力後
//debug($arg1);
//debug($this->request->data);
			$this->SetPublicData();
			$data = $this->request->data;
			if(isset($data['check_id'])){
				if($data['form_return'] == 0)
					$this->redirect(array('controller' => 'kara1', 'action' => 'enter_room', "3", $arg1));

				$id = $this->SalesSlip->field('id', array('check_id'=>$data['check_id']), 'id DESC');
//debug($id);
//debug($data['unit']);
//exit();
				if($data['unit']=="%")
					$n = $data['value'] / 100 * $data['qty'];
				else
					$n = $data['value'] * $data['qty'];

				if($id > 0){
					$this->SalesSlip->updateAll(array('room_id'=>$data['room_id'], 'discount'=>$n), array('id'=>$id));
				}else{
					$save_array = array('id'=>NULL, 'room_id'=>$data['room_id'], 'check_id'=>$data['check_id'], 'discount'=>$n);
					$this->SalesSlip->save($save_array);
				}
				$cmd=0;
				return $cmd;
			}
		}
		return $cmd;
	}





	private function GetSessionData(){
		session_start();
		$this->_check_id = $_SESSION['check_id'];
		if($this->_check_id){
			//echo $_SESSION['check_id'];//セッションを読み込み変数を呼び出す
			$s = hexdec($this->_check_id);
//debug($this->_check_id);
//debug($s);
			$st = substr($s, 0, strlen($s)-4);
			$dt = date("Y-m-d H:i:s", (int)$st);
			$this->_room_id = (int)substr($s, strlen($s)-4, 2);
			$this->_staff_id = (int)substr($s, strlen($s)-2, 2);
		}
	}

	private function SetPublicData(){
		$data = $this->request->data;
//debug($this->request->data);
//debug($this->_check_id);
//exit();
		if(isset($data['check_id'])){
			if($data['check_id'] != "")
				$this->_check_id = $data['check_id'];
		}
		if($this->_check_id == ""){
			session_start();
			$this->_check_id = $_SESSION['check_id'];//変数をセッションに登録
			if($this->_check_id == ""){
				$error_msg = "エラー　CHECK_IDがNULLです。";
				debug($error_msg);
			}
		}
		$this->set('_check_id', $this->_check_id);

		if(isset($data['room_id'])){
			if($data['room_id'] > 0)
				$this->_room_id = $data['room_id'];
		}
		if($this->_room_id == 0){
			$error_msg = "エラー　ルーム番号が0です。";
			debug($error_msg);
		}
		$this->set('_room_id', $this->_room_id);

		if(isset($data['kind']))
			$this->_kind = $data['kind'];
		$this->set('_kind', $this->_kind);

		if(isset($data['error_msg']))
			$this->_error_msg = $data['error_msg'];
		$this->set('_error_msg', $this->_error_msg);

		if(isset($data['rate_plan_id'])){
			if($data['rate_plan_id'] > 0)
				$this->_rate_plan_id = $data['rate_plan_id'];
		}
		$this->set('_rate_plan_id', $this->_rate_plan_id);

		if(isset($data['enter_room_time'])){
			if($data['enter_room_time'])
				$this->_enter_room_time = $data['enter_room_time'];
		}
		$this->set('_enter_room_time', $this->_enter_room_time);

		if(isset($data['leave_room_time'])){
			if($data['leave_room_time'])
				$this->_leave_room_time = $data['leave_room_time'];
		}
		$this->set('_leave_room_time', $this->_leave_room_time);

		if(isset($data['available_time'])){
			if($data['available_time'])
				$this->_available_time = $data['available_time'];
		}
		$this->set('_available_time', $this->_available_time);

		if(isset($data['staff_id'])){
			if($data['staff_id'])
				$this->_staff_id = $data['staff_id'];
		}
		$this->set('_staff_id', $this->_staff_id);

		if(isset($data['general'])){
			if($data['general'])
				$this->_general = $data['general'];
		}
		$this->set('_general', $this->_general);

		if(isset($data['member'])){
			if($data['member'])
				$this->_member = $data['member'];
		}
		$this->set('_member', $this->_member);

		if(isset($data['member2'])){
			if($data['member2'])
				$this->_member2 = $data['member2'];
		}
		$this->set('_member2', $this->_member2);

		if(isset($data['free'])){
			if($data['free'])
				$this->_free = $data['free'];
		}
		$this->set('_free', $this->_free);

		if(isset($data['people'])){
			if($data['people'])
				$this->_people = $data['people'];
		}
		$this->set('_people', $this->_people);

		if(isset($data['male'])){
			if($data['male'])
				$this->_male = $data['male'];
		}
		$this->set('_male', $this->_male);

		if(isset($data['female'])){
			if($data['female'])
				$this->_female = $data['female'];
		}
		$this->set('_female', $this->_female);

		if(isset($data['children'])){
			if($data['children'])
				$this->_children = $data['children'];
		}
		$this->set('_children', $this->_children);

		if(isset($data['member_id'])){
			if($data['member_id'])
				$this->_member_id = $data['member_id'];
		}
		$this->set('_member_id', $this->_member_id);

		if(isset($data['grade_id'])){
			if($data['grade_id'])
				$this->_grade_id = $data['grade_id'];
		}
		$this->set('_grade_id', $this->_grade_id);

		if(isset($data['room_charge'])){
			if($data['room_charge'])
				$this->_room_charge = $data['room_charge'];
		}
		$this->set('_room_charge', $this->_room_charge);

		if(isset($data['sales'])){
			if($data['sales'])
				$this->_sales = $data['sales'];
		}
		$this->set('_sales', $this->_sales);

		if(isset($data['discount_id'])){
			if($data['discount_id'])
				$this->_discount_id = $data['discount_id'];
		}
		$this->set('_discount_id', $this->_discount_id);

		if(isset($data['discount'])){
			if($data['discount'])
				$this->_discount = $data['discount'];
		}
		$this->set('_discount', $this->_discount);

		if(isset($data['premium_id'])){
			if($data['premium_id'])
				$this->_premium_id = $data['premium_id'];
		}
		$this->set('_premium_id', $this->_premium_id);

		if(isset($data['premium'])){
			if($data['premium'])
				$this->_premium = $data['premium'];
		}
		$this->set('_premium', $this->_premium);

		if(isset($data['other'])){
			if($data['other'])
				$this->_other = $data['other'];
		}
		$this->set('_other', $this->_other);

		if(isset($data['tax'])){
			if($data['tax'])
				$this->_tax = $data['tax'];
		}
		$this->set('_tax', $this->_tax);

		if(isset($data['total'])){
			if($data['total'])
				$this->_total = $data['total'];
		}
		$this->set('_total', $this->_total);

		if(isset($data['staff_id'])){
			if($data['staff_id'])
				$this->_staff_id = $data['staff_id'];
		}
		$this->set('_staff_id', $this->_staff_id);

		if(isset($data['avance_payment'])){
			if($data['avance_payment'])
				$this->_avance_payment = $data['avance_payment'];
		}

		$this->set('_avance_payment', $this->_avance_payment);

	}
	


	private function MakeHidden(){
		$hidden  = "<input type=\"hidden\" name=\"check_id\" value=\"".$this->_check_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"room_id\" value=\"".$this->_room_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"kind\"  value=\"".$this->_kind."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"error_msg\"  value=\"".$this->_error_msg."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"rate_plan_id\"  value=\"".$this->_rate_plan_id."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"rate_plan_id\"  value=\"".$this->_rate_plan_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"enter_room_time\"  value=\"".$this->_enter_room_time."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"leave_room_time\"  value=\"".$this->_leave_room_time."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"available_time\"  value=\"".$this->_available_time."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"staff_id\"  value=\"".$this->_staff_id."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"general\"  value=\"".$this->_general."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"member\"  value=\"".$this->_member."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"member2\"  value=\"".$this->_member2."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"free\"  value=\"".$this->_free."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"people\"  value=\"".$this->_people."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"male\"  value=\"".$this->_male."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"female\"  value=\"".$this->_female."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"children\"  value=\"".$this->_children."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"member_id\"  value=\"".$this->_member_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"grade_id\"  value=\"".$this->_grade_id."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"room_charge\"  value=\"".$this->_room_charge."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"sales\"  value=\"".$this->_sales."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"discount_id\"  value=\"".$this->_discount_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"discount\"  value=\"".$this->_discount."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"premium_id\"  value=\"".$this->_premium_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"premium\"  value=\"".$this->_premium."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"other\"  value=\"".$this->_other."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"tax\"  value=\"".$this->_tax."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"total\"  value=\"".$this->_total."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"avance_payment\"  value=\"".$this->_avance_payment."\">\r\n";
//debug($hidden);		
		$this->set('hidden', $hidden);
	}



}
