<?php
//	http://localhost:81/psp/kara/home
//  https://s.pierson.shop/psp/kara/

//	ALTER TABLE `room_info` ADD `status` TINYINT NOT NULL DEFAULT '0' AFTER `OrderNo`;

// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');

class Kara1checkinController extends AppController {
	public $name = 'Kara1checkin';
	public $uses = array('Store', 'Staff', 'Member', 'RoomGroup', 'RoomInfo', 'RatePlan', 'CheckDT1', 
					'Bumon', 'MenuMSTR', 'MenuMOD', 'CheckDT1', 'CartDT7', 'CartORD', 'Config');
		//array('Store','MenuMSTR', 'MenuMOD', 
		//					'CheckDT1', 'CartDT7', 'CartORD', 'Config', 'TopMenu',
	public $layout = 'kara1checkin';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;
	public $_server_name =  "";
	public $_server_name2 =  "";

	public $_up_date = "";

	public $_open_time = NULL;
	public $_close_time = NULL;
	public $_page_pattern = 0;
	public $_max_room_no = 10;


	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "http://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

/********** MOD 2023/06/18 ******************************************************/
		$this->_server_name =  substr($_SERVER['SERVER_NAME'], 0, strpos($_SERVER['SERVER_NAME'], ".") );
		$this->_store_id = preg_replace('/[^0-9]/', '', $this->_server_name);
/********** MOD 2023/06/18 ******************************************************/

		//$this->_server_name = substr($_SERVER['SERVER_NAME'], 0, 2);
		//if($this->_server_name == "s.")
		//	$this->_server_name = "s";
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "から次郎".$this->_server_name2;
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff'));
	}
	
///======================================================///
	public function staff($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "担当者選択".$this->_server_name2;
		$error_msg = "";

		$search['id'] = "";
		$search['name'] = "";
		$search['flag'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
			$search = $this->request->data['Staff'];
//debug($search);

			if(isset($search['id'])){
				$search['id'] = (int)mb_convert_kana($search['id'], "KVa");
				if($search['id']){
					$conditions['id'] = (int)$search['id'];
				}
			}else{
				$search['id'] = "";
			}

			if(isset($search['name'])){
				if($search['name']){
					$conditions['name like'] = '%'.$search['name'].'%';
				}
			}else{
				$search['name'] = "";
			}

			if(isset($search['flag'])){
				if($search['flag'] == 1){
					$conditions['flag'] = 0;
				}
			}else{
				$search['flag'] = "";
			}

		}
		
			
//debug($conditions);
		$this->paginate = array(
			'Staff' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'id', 		// desc
				'conditions' => $conditions,
				//'group' => array('flag', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('Staff');
//debug($data);
//exit();

		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function staff_edit($staff_id = 0){
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$staff_name = "";
		$main_title = "担当者選択(Staff)".$this->_server_name2;

//debug($this->request->data);
		if($this->request->data){
			$staff = $this->request->data['Staff'];
//debug($staff);
//exit();
			if ($staff['submit'] == "削除"){
//debug($staff);
				$this->Staff->delete($staff['id']);
				$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff'));

			}elseif ($staff['submit'] == "更新"){
				$staff['flag'] = mb_convert_kana($staff['flag'], "KVa");
				if($staff['id'] > 0){
					$staff_id = $staff['id'];
//debug($staff);
					$ret = $this->Staff->save($staff);
//exit();
					$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff'));
				}
			}elseif ($staff['submit'] == "新規"){
				$staff['flag'] = mb_convert_kana($staff['flag'], "KVa");
				$conditions = array('name like'=>$staff['name']);
				$data = $this->Staff->find('first', array('conditions'=>$conditions));
				if(count($data) == 0){
					$staff_id = $staff['id'] = null;
					$ret = $this->Staff->save($staff);
					$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff'));
				}
				$msg = $data['Staff']['name']."　は既にデータがあります";

			}else{
				debug("エラー");
				//exit();
			}

		}

		if($staff_id > 0){
			$conditions = array('id'=>$staff_id);
			$data = $this->Staff->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($staff_id > 0)
				$error_msg = "データがない";
		}
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function staff_select($id=0){
//debug($id);
		$this->autoRender = false;	//View File なし
		$conditions = array('id'=>$id);
		$data = $this->Staff->find('first', array('conditions'=>$conditions));
		if(count($data) == 0)
			$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff', "Staffがない"));

		$staff_name = $data['Staff']['name'];
//debug($staff_name);
//debug($data);
//exit();
		session_start();
		$_SESSION['staff_name'] = $staff_name;
		$this->redirect(array('controller' => 'kara1checkin', 'action' => 'room'));
	}

///======================================================///
	public function room($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "部屋選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['RoomID'] = "";
		$search['GroupID'] = "";
		$search['RoomName'] = "";
		$search['OrderNo'] = "";
		$search['status'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
//debug($this->request->data['Check']);
			$search = $this->request->data['RoomInfo'];

			if(isset($search['RoomID'])){
				$search['RoomID'] = (int)mb_convert_kana($search['RoomID'], "KVa");
				if($search['RoomID']){
					$conditions['RoomID'] = $search['RoomID'];
				}
			}else{
				$search['RoomID'] = "";
			}

			if(isset($search['RoomName'])){
				if($search['RoomName']){
					$conditions['RoomName like'] = '%'.$search['RoomName'].'%';
				}
			}else{
				$search['RoomName'] = "";
			}

			if(isset($search['status'])){
				if($search['status'] == 1){
					$conditions['status'] = "0";
				}
			}else{
				$search['status'] = "";
			}
		}
		
			
//debug($conditions);
		$this->paginate = array(
			'RoomInfo' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'RoomID', 		// desc
				'conditions' => $conditions, 
				//'group' => array('flag', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('RoomInfo');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function room_edit($room_id = 0){
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "部屋選択(Staff)".$this->_server_name2;

//debug($this->request->data);
		if($this->request->data){
			$room = $this->request->data['RoomInfo'];
//debug($room);
//exit();
			if ($room['submit'] == "削除"){
//debug($room);
				$this->RoomInfo->delete($room['id']);
				$this->redirect(array('controller' => 'kara1checkin', 'action' => 'room'));

			}elseif ($room['submit'] == "更新"){
				$room['status'] = mb_convert_kana($room['status'], "KVa");
				if($room['id'] > 0){
					$room_id = $room['id'];
//debug($room);
					$ret = $this->RoomInfo->save($room);
					
					$id = $this->CheckDT1->field('id', array('room_no'=>$room['RoomID']), 'id DESC');
					$this->CheckDT1->set('id', $id);
					$this->CheckDT1->saveField('dt4_flag', $room['DT4']);		//1 入室、2タイムオーバー、3退室・注文不可、4清掃中、0清掃終了
debug($room['DT4']);
//					$this->redirect(array('controller' => 'kara1checkin', 'action' => 'room'));
				}
			}elseif ($room['submit'] == "新規"){
				$room['status'] = mb_convert_kana($room['status'], "KVa");
				$conditions = array('RoomID'=>$room['RoomID']);
				$data = $this->RoomInfo->find('first', array('conditions'=>$conditions));
				if(count($data) == 0){
					$room_id = $room['id'] = null;
					$ret = $this->RoomInfo->save($room);
					$this->redirect(array('controller' => 'kara1checkin', 'action' => 'room'));
				}
				$msg = $data['RoomInfo']['RoomID']."　は既にデータがあります";

			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($room_id > 0){
			$conditions = array('id'=>$room_id);
			$data = $this->RoomInfo->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($room_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function room_select($id=0){
		//$top_title = $this->session_proc();

		$this->autoRender = false;	//View File なし

		$conditions = array('id'=>$id);
		$data = $this->RoomInfo->find('first', array('conditions'=>$conditions));
		if(count($data) == 0)
			$this->redirect(array('controller' => 'kara1checkin', 'action' => 'room', "RoomIDがない"));

		$RoomID = $data['RoomInfo']['RoomID'];
//debug($data);
//exit();
		session_start();
		$_SESSION['RoomID'] = $RoomID;
//debug($_SESSION['RoomID']);
//exit();
		$this->redirect(array('controller' => 'kara1checkin', 'action' => 'member'));
	}




///======================================================///
	public function member($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "会員選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['member_no'] = "";
		$search['name'] = "";
		$search['memo'] = "";
		$search['grade'] = "";
		$search['birthday'] = "";
		$search['expiration'] = "";
		$search['usage_amount'] = "";
		$search['visits'] = "";
		$search['last_visit'] = "";
		$search['point'] = "";
		$search['table1'] = "";
		$search['table2'] = "";
		$search['table3'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
			$search = $this->request->data['Member'];
			if(isset($search['member_no'])){
				$search['member_no'] = mb_convert_kana($search['member_no'], "KVa");
				if($search['member_no']){
					$conditions['member_no'] = $search['member_no'];
				}
			}else{
				$search['member_no'] = "";
			}
			if(isset($search['name'])){
				if($search['name']){
					$conditions['name like'] = '%'.$search['name'].'%';
				}
			}else{
				$search['name'] = "";
			}

			if(isset($search['memo'])){
				if($search['memo']){
					$conditions['memo like'] = '%'.$search['memo'].'%';
				}
			}else{
				$search['memo'] = "";
			}

			if(isset($search['grade'])){
				if($search['grade']){
					$conditions['grade'] = $search['grade'];
				}
			}else{
				$search['grade'] = "";
			}

			if(isset($search['birthday'])){
				if($search['birthday']){
					$conditions['birthday like'] = '%'.$search['birthday'].'%';
				}
			}else{
				$search['birthday'] = "";
			}
		}
		
			
//debug($conditions);
//exit();
		$this->paginate = array(
			'Member' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'name', 		// desc
				'conditions' => $conditions, 
			), 
		);
//debug($search);
		$data = $this->paginate('Member');
		$this->set('data', $data);

		$conditions = array();	//'check_id'=>$this->_check_id
		$order = array('member_no' => 'ASC');	//ASC | DESC
		$data1 = $this->Member->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('data1', $data1);

		$this->set('error_msg', $error_msg);
		$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
//exit();
	}	

	public function member_edit($member_id=0){
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "会員選択(Member)".$this->_server_name2;

		if($this->request->data){
			$member = $this->request->data['Member'];
//debug($member);
//exit();
			if ($member['submit'] == "削除"){
//debug($member);
				$this->Member->delete($member['id']);
				$this->redirect(array('controller' => 'kara1checkin', 'action' => 'member'));

			}elseif ($member['submit'] == "更新"){
				$member['status'] = mb_convert_kana($member['status'], "KVa");
				if($member['id'] > 0){
					$member_id = $member['id'];
//debug($member);
					$ret = $this->Member->save($member);
					$this->redirect(array('controller' => 'kara1checkin', 'action' => 'member'));
				}
			}elseif ($member['submit'] == "新規"){
//debug($member);
				$member['status'] = mb_convert_kana($member['status'], "KVa");
				if(!$member['member_no']){
					$msg = "会員番号がありません";
				}elseif(!$member['name']){
					$msg = "会員名がありません";
				}elseif(!$member['grade']){
					$msg = "会員グレードがありません";
				}elseif(!$member['birthday']){
					$msg = "誕生日がありません";

				}else{
					$conditions = array('member_no'=>$member['member_no']);
					$data = $this->Member->find('first', array('conditions'=>$conditions));
					if(count($data) == 0){
						$member['id'] = null;
						$ret = $this->Member->save($member);
						$this->redirect(array('controller' => 'kara1checkin', 'action' => 'member'));
					}
					$msg = $data['Member']['member_no']."　は既にデータがあります";
				}
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($member_id > 0){
			$conditions = array('id'=>$member_id);
			$data = $this->Member->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($member_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);	
	}

	public function member_select(){
		//$top_title = $this->session_proc();
		$this->autoRender = false;	//View File なし
		$members = explode('|', $this->request->data['Member']['members']);
		for($i=0; $i<count($members); $i++){
			$member = explode('・', $members[$i]);
			$member_nos[$i] = $member[0];
		}
		$d = implode(',', $member_nos);
//debug($members);
//debug($member_nos);

		session_start();
		$_SESSION['member_nos'] = implode(',', $member_nos);
//debug($_SESSION['member_nos']);
//exit();
		$this->redirect(array('controller' => 'kara1checkin', 'action' => 'plan'));
	}



///======================================================///

	public function plan($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "料金選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['plan'] = "";
		$search['comment'] = "";
		$search['flag'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
//debug($this->request->data['RatePlan']);
			$search = $this->request->data['RatePlan'];
			if(isset($search['id'])){
				if($search['id']){
					$conditions['id'] = $search['id'];
				}
			}else{
				$search['id'] = "";
			}
			if(isset($search['plan'])){
				if($search['plan']){
					$conditions['plan like'] = '%'.$search['plan'].'%';
				}
			}else{
				$search['plan'] = "";
			}

			if(isset($search['comment'])){
				if($search['comment']){
					$conditions['comment like'] = '%'.$search['comment'].'%';
				}
			}else{
				$search['comment'] = "";
			}
			if(isset($search['flag'])){
				if($search['flag'] == 1){
					$conditions['flag'] = 0;
				}
			}else{
				$search['flag'] = "";
			}

		}
		
			
//debug($conditions);
//exit();
		$this->paginate = array(
			'RatePlan' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'id', 		// desc
				'conditions' => $conditions, 
				//'group' => array('flag', 'checkin_time'),
			), 
		);
		$data = $this->paginate('RatePlan');
		$this->set('data', $data);
//debug($search);
		$this->set('error_msg', $error_msg);
		$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function plan_edit($plan_id=0){
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "プラン選択(RatePlan)".$this->_server_name2;

		if($this->request->data){
			$plan = $this->request->data['RatePlan'];
//debug($plan);
//exit();
			if ($plan['submit'] == "削除"){
//debug($plan);
				$this->RatePlan->delete($plan['id']);
				$this->redirect(array('controller' => 'kara1checkin', 'action' => 'plan'));

			}elseif ($plan['submit'] == "更新"){
				$plan['flag'] = mb_convert_kana($plan['flag'], "KVa");
				if($plan['id'] > 0){
					$plan_id = $plan['id'];
//debug($plan);
					$ret = $this->RatePlan->save($plan);
					$this->redirect(array('controller' => 'kara1checkin', 'action' => 'plan'));
				}
			}elseif ($plan['submit'] == "新規"){
//debug($plan);
				$plan['flag'] = mb_convert_kana($plan['flag'], "KVa");
				if(!$plan['plan']){
					$msg = "プラン名がありません";
				}else{
					$conditions = array('plan'=>$plan['plan']);
					$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
					if(count($data) == 0){
						$plan['id'] = null;
						$ret = $this->RatePlan->save($plan);
						$this->redirect(array('controller' => 'kara1checkin', 'action' => 'plan'));
					}
					$msg = $data['RatePlan']['plan']."　は既にデータがあります";
				}
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($plan_id > 0){
			$conditions = array('id'=>$plan_id);
			$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($plan_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);	
	}

	public function plan_select($id=0){
//debug($id);
		$this->autoRender = false;	//View File なし
		$conditions = array('id'=>$id);
		$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
		if(count($data) == 0)
			$this->redirect(array('controller' => 'kara1checkin', 'action' => 'plan', "プランがない"));

		$plan = $data['RatePlan']['plan'];
//debug($staff_name);
//debug($data);
//exit();
		session_start();
		$_SESSION['plan'] = $plan;
		$this->redirect(array('controller' => 'kara1checkin', 'action' => 'confirm'));
	}

///======================================================///
	public function confirm($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "入室確認".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		if($this->request->data){
			$confirm = $this->request->data['CheckDT1'];
//debug($confirm);
//exit();
			if($confirm['submit'] == "入室処理確定" or $confirm['submit'] == "更新"){
//debug($confirm);
//exit();
				$confirm['staff_id'] = $this->Staff->field("id", array('name'=>$confirm['staff_name']));

				$m = $confirm['leave_remain_time1'].":".$confirm['leave_remain_time2'].":00";
				$confirm['leave_remain_time'] = $this->convertToMin($m);

				$confirm['id'] = null;
				$this->CheckDT1->save($confirm);
//debug($confirm);
//exit();
				if($confirm['submit'] == "入室処理確定")
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				$room_no = $confirm['room_no'];
			}elseif ($confirm['submit'] == "入室処理キャンセル"){
				//session_start();
				session_destroy();
				$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff'));
			}
		}

		$sdata = explode('　', $top_title);
//debug($sdata);
		if(count($sdata) != 5){
			$error_msg = "";
			if(!strstr($top_title, "担当者："))
				$error_msg .= "　担当者が選択されてない";
			if(!strstr($top_title, "部屋番号："))
				$error_msg .= "　部屋番号が選択されてない";
			if(!strstr($top_title, "会員番号："))
				$error_msg .= "　会員が選択されてない";
			if(!strstr($top_title, "プラン："))
				$error_msg .= "　プランが選択されてない";
			if($error_msg)
				$this->redirect(array('controller' => 'kara1checkin', 'action' => 'staff', $error_msg));
		}

		$staff_name = mb_substr($sdata[1], mb_strpos($sdata[1], "：")+1);
		$room_no = mb_substr($sdata[2], mb_strpos($sdata[2], "：")+1); //部屋番号
//debug($sdata);

		$data['CheckDT1']['id'] = 0;

		$check_id = dechex(strtotime('now').sprintf('%02d', $room_no));
		$data['CheckDT1']['check_id'] = $check_id;		//受付ID

		$data['CheckDT1']['room_no'] = $room_no;	//部屋番号
		$data['CheckDT1']['over_flag'] = 0;		//超過有無
		
		/******************************/
		$data['CheckDT1']['leave_remain_time'] = "1:00";	//退出残時間
//debug($data['CheckDT1']['leave_remain_time']);
		/******************************/


		/******************************/
		if(date("H") >= 7 and (date("H") <= 23))
			$sales_date = strtotime('now');
		else
			$sales_date = strtotime("-1 day");

		$open_time = $this->Store->field("open_time", array('id'=>1));	//開店時間
		$close_time = $this->Store->field("close_time", array('id'=>1));
//		$close_time = "23:59:59";

		$store_open_time = new DateTime(date("Y-m-d ", $sales_date).$open_time);	//店舗開店時間
		$store_close_time = new DateTime(date("Y-m-d ", $sales_date).$close_time);	//店舗閉店時間
		$ct = date("Y-m-d ", $sales_date).$close_time;
		$store_close_time2 = new DateTime("+1 day ".$ct);	

		$now_time = new DateTime(date("Y-m-d H:i:s"));
		if($store_close_time > $store_open_time)
			$entry_close_time = $store_close_time->diff($now_time);
		else
			$entry_close_time = $store_close_time2->diff($now_time);
		$ect = $entry_close_time->format('%H').":".$entry_close_time->format('%i');
debug($store_open_time->format('Y-m-d H:i:s'));
debug($store_close_time->format('Y-m-d H:i:s'));
debug($store_close_time2->format('Y-m-d H:i:s'));
debug($now_time->format('Y-m-d H:i:s'));
debug($ect);
		$data['CheckDT1']['entry_close_time'] = $this->convertToMin($ect);	//閉店までの時間
debug($data['CheckDT1']['entry_close_time']);
		/******************************/

		$m_array = explode(",", mb_substr($sdata[3], mb_strpos($sdata[3], "：")+1));
		$data['CheckDT1']['people'] = count($m_array);		//人数
		
		$plan = mb_substr($sdata[4], mb_strpos($sdata[4], "：")+1);
		$data['CheckDT1']['unit_price_kind'] = 0;			//単価種類
		$data['CheckDT1']['drink_free_kind'] = 0;			//飲み放題種類
		$data['CheckDT1']['drink_free_time'] = 0;			//飲み放題残り時間

		$data['CheckDT1']['dt4_flag'] = 0;					//室内状態
		$data['CheckDT1']['staff_call'] = 0;			//スタッフ・コール
		$data['CheckDT1']['staff_call_time'] = "";		//スタッフ・コール時間
		$data['CheckDT1']['up_date'] = date("Y-m-d H:i:s");					//更新日時

		$this->set('data', $data);
//debug($search);
		$this->set('error_msg', $error_msg);
		//$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
		$data2 = $this->get_session($top_title);
//debug($data2);
		if(isset($confirm['staff_name'])){
			if($confirm['staff_name'])
				$data2['staff_name'] = $confirm['staff_name'];
		}
		$conditions = array('name'=>$data2['staff_name']);
		$staff = $this->Staff->find('first', array('conditions'=>$conditions));
		$this->set('staff', $staff['Staff']);
//debug($staff['Staff']);

		
		$conditions = array('member_no'=>explode(",", $data2['member_no']));
//debug($conditions);
		$member = $this->Member->find('all', array('conditions'=>$conditions));
		$this->set('member', $member);
//debug($member);
		
		if(isset($confirm['room_no'])){
			if($confirm['room_no'])
				$room_no = $confirm['room_no'];
		}
		$conditions = array('RoomID'=>$room_no);
		$room_info = $this->RoomInfo->find('first', array('conditions'=>$conditions));
		$this->set('room_info', $room_info['RoomInfo']);
debug($room_info['RoomInfo']);

		$conditions = array('plan'=>$data2['plan_name']);
		$rate_plan = $this->RatePlan->find('first', array('conditions'=>$conditions));
		$this->set('rate_plan', $rate_plan['RatePlan']);
//debug($rate_plan['RatePlan']);
//exit();
	}
//	public $uses = array('Staff', 'Member', 'RoomGroup', 'RoomInfo', 'RatePlan', 'CheckDT1');


	private function convertToMin($time="01:10:20"){
		$tArry=explode(":",$time);
		$hour=$tArry[0]*60;//時間→分
		if(isset($tArry[2]))
			$secnd = round($tArry[2]/60,2);//秒→分　少数第2を丸めてる
		else
			$secnd = 0;
		$mins=$hour+$tArry[1]+$secnd;//分だけを足す
		return $mins;
	}


	private function get_session($top_title){
		$a = explode('　', $top_title);
		for($i=0; $i<count($a); $i++){
			if(strstr($a[$i], "担当者："))
				$data2['staff_name'] = mb_substr($a[$i], mb_strlen("担当者："));
			if(strstr($a[$i], "部屋番号："))
				$data2['room_no'] = mb_substr($a[$i], mb_strlen("部屋番号："));
			if(strstr($a[$i], "会員番号："))
				$data2['member_no'] = mb_substr($a[$i], mb_strlen("会員番号："));

			if(strstr($a[$i], "プラン："))
				$data2['plan_name'] = mb_substr($a[$i], mb_strlen("プラン："));
		}
		return $data2;
//exit();
	}




///======================================================///

	private function session_proc(){
		$top_title = "";
		session_start();
		if(isset($_SESSION['staff_name']))
			$top_title .= "　担当者：".$_SESSION['staff_name'];
		
		if(isset($_SESSION['RoomID']))
			$top_title .= "　部屋番号：".$_SESSION['RoomID'];
	
		if(isset($_SESSION['member_nos']))
			$top_title .= "　会員番号：".$_SESSION['member_nos'];
		if(isset($_SESSION['plan']))
			$top_title .= "　プラン：".$_SESSION['plan'];
		return $top_title;
	}





	

}
