<?php
//	http://localhost/psp/admin2/check
//  http://s.piearson.shop/psp/admin2/check

// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');

class Admin2Controller extends AppController {
	public $name = 'Admin2';
	public $uses = array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
						'CheckDT1', 'CartDT7', 'CartORD', 'Config', 'TopMenu',
						'CheckDT1Old', 'CartDT7Old', 'CartORDOld');
							//, 'Menu', 'Cart', 'OldCart', 'Check', 'OldCheck'
	public $layout = 'admin2';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;
	public $_server_name =  "";
	public $_server_name2 =  "";

	public $_store_id = 1;
	public $_cart_id = "";
	public $_order_no = "";
	public $_room_no = "";

	public $_order_send = "";
	public $_order_time = NULL;

	public $_deliver_send = "";
	public $_deliver_time = NULL;

	public $_checkin_time = NULL;
	public $_checkout_time = NULL;

	public $_menu_id = 0;
	public $_menu_name = "";
	public $_room_use = 0;

	public $_cat1 = "";
	public $_cat2 = "";
	public $_photo_no = "";

	public $_bumon_id = "";
	public $_cat2name = "";
	public $_cat2flag = "";
	public $_up_date = "";

	public $_open_time = NULL;
	public $_close_time = NULL;
	public $_page_pattern = 0;
	public $_max_room_no = 10;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "https://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->_server_name = substr($_SERVER['SERVER_NAME'], 0, 2);
		if($this->_server_name == "s.")
			$this->_server_name = "s";
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "管理画面".$this->_server_name2;
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'admin2', 'action' => 'check'));
	}
	
	

	public function check($debug_room_no=0, $debug_unit_price_kind="", $debug_drink_free_kind=""){
//debug($debug_room_no);
//debug($debug_unit_price_kind);
//debug($debug_drink_free_kind);
		$main_title = "OLd入退室管理".$this->_server_name2;
		$this->set('main_title', $main_title);
//$this->Common->ResetModelID('MenuMSTR');
		$error_msg = "";
		//$targetTime = $this->EvaluateTime($mode="open");
		//$checkin_time = date('Y-m-d H:i:s', strtotime("-6 hour", $targetTime));
//debug($checkin_time);

		//$conditions['order_no'] = $this->_order_no;
		//$conditions['checkin_time >'] = $checkin_time;
		//$conditions['checkout_time'] = NULL;

		$search['id'] = "";
		$search['room_use'] = "";
		$search['room_no'] = "";
		$search['drink_free'] = "";

		
		$conditions = array();
		if($this->request->data){
//debug($this->request->data['Check']);
			$search = $this->request->data['CheckDT1Old'];
			if($search['id'])
				$conditions['id'] = $search['id'];
			if(isset($search['room_use'])){
				if($search['room_use']){
					$conditions['dt4_flag'] = 0;
				}
			}else{
				$search['room_use'] = "";
			}
			if($search['room_no'])
				$conditions['room_no'] = $search['room_no'];

			if(isset($search['drink_free'])){
				if($search['drink_free']){
					$conditions['drink_free_kind >'] = 0;
				}
			}else{
				$search['drink_free'] = "";
			}
			//$conditions['MenuMSTR.menu_name like'] = '%'.$this->_menu_name.'%';
		}
		
			
//debug($conditions);
		$this->paginate = array(
			'CheckDT1Old' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 20,
				'order' => 'room_no', 		// desc
				'conditions' => $conditions, 
				//'group' => array('room_no', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('CheckDT1Old');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		
		if(!$debug_room_no)
			$debug_room_no = $this->Config->field('debug_room_no', array('id'=>1));
		$this->set('debug_room_no', $debug_room_no);

		$debug_check_id = $this->Config->field('debug_check_id', array('id'=>1));
		$this->set('debug_check_id', $debug_check_id);

		if($debug_unit_price_kind == "");
			$debug_unit_price_kind = $this->Config->field('debug_unit_price_kind', array('id'=>1));
		$this->set('debug_unit_price_kind', $debug_unit_price_kind);
//debug($debug_unit_price_kind);

		if($debug_drink_free_kind == "")
			$debug_drink_free_kind = $this->Config->field('debug_drink_free_kind', array('id'=>1));
//debug($debug_drink_free_kind);
		$this->set('debug_drink_free_kind', $debug_drink_free_kind);


//debug($data);
	}

	public function check_edit($check_id=0){
		$main_title = "入退室管理編集".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		if($this->request->data){
			$check = $this->request->data['CheckDT1Old'];
			if($this->request->data['submit'] == "更新"){
//debug($this->request->data);
//debug($this->request->data['CheckDT1Old']);
//debug($check);
				if (isset($check['id'])){
					if($check['id'] > 0){
						$check_id = $check['id'];
						$ret = $this->CheckDT1Old->save($check);
					}
  				}
			}elseif($this->request->data['submit'] == "削除"){
				if (isset($check['id'])){
					if($check['id'] > 0){
						$check_id = $check['id'];
						$ret = $this->CheckDT1Old->delete($check_id);
						$this->redirect(array('controller' => 'admin2', 'action' => 'check'));
					}
  				}
				$this->redirect(array('controller' => 'admin2', 'action' => 'check'));
			}
			$check_id = $this->request->data['CheckDT1Old']['id'];
		}
//debug($check_id);
		if($check_id > 0){
			$conditions = array('id'=>$check_id);
			$data = $this->CheckDT1Old->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}




	public function bumon(){
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理(Bumon)".$this->_server_name2);
		$conditions = $this->GetBumonRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'Bumon' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Bumon.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Bumon');
		$this->set('data', $data);

		//**********************
		$fields = array('cat1');
		$conditions = array();
		$group = array('cat1');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat1_array[$i] = $menu[$i]['MenuMSTR']['cat1'];
			$this->set('cat1_array', $cat1_array);
		}
		//$cat1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('cat2');
		if(isset($search['cat1'])){
			if($search['cat1'])
				$conditions = array('cat1' => $search['cat1']);
		}else
			$conditions = array();
		$group = array('cat2');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat2_array[$i] = $menu[$i]['MenuMSTR']['cat2'];
			$this->set('cat2_array', $cat2_array);
		}
		//**********************
		
		$this->set('error_msg', $error_msg);	
	}


	public function bumon_edit($bumon_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(Bumon)".$this->_server_name2);
//debug($this->request->data);
		if($this->request->data){
			$bumon = $this->request->data['Bumon'];
//debug($bumon);
			if ($bumon['submit'] == "削除"){
				//$this->Bumon->delete($bumon['id']);
				$this->redirect(array('controller' => 'admin2', 'action' => 'bumon'));

			}elseif ($bumon['submit'] == "更新"){
				if($bumon['id'] > 0){
					$bumon_id = $bumon['id'];
//debug($bumon);
					$ret = $this->Bumon->save($bumon);
				}
				//$this->redirect(array('controller' => 'admin2', 'action' => 'bumon'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Bumon");	//'

		if($bumon_id > 0){
			$conditions = array('id'=>$bumon_id);
			$data = $this->Bumon->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function menu(){
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);
		$conditions = $this->GetMenuRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'MenuMSTR' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'MenuMSTR.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('MenuMSTR');
		$this->set('data', $data);

		//**********************
		$fields = array('cat1');
		$conditions = array();
		$group = array('cat1');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat1_array[$i] = $menu[$i]['MenuMSTR']['cat1'];
			$this->set('cat1_array', $cat1_array);
		}
		//$cat1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('cat2');
		if(isset($search['cat1'])){
			if($search['cat1'])
				$conditions = array('cat1' => $search['cat1']);
		}else
			$conditions = array();
		$group = array('cat2');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat2_array[$i] = $menu[$i]['MenuMSTR']['cat2'];
			$this->set('cat2_array', $cat2_array);
		}
		//**********************

		$this->set('error_msg', $error_msg);


/*
$this->Paginator->numbers(array(
'first' => '', //ページ数が多いとき最初のページを出すか（数字で指定）
'last' => '',//ページ数が多いとき最後のページを出すか（数字で指定）
'before'=>'',//ページ番号の前に出力する文字を指定
'after'=>'',//ページ番号の後に出力する文字を指定
'modulus'=>'',//ページ番号を幾つ表示するか（デフォルト値：8）
'separator'=>'',//ページ番号を区切る文字列（デフォルト値：|）
'ellipsis'=>'',//省略される時に表示される文字列（デフォルト値：・・・）
'tag'=>'',//ページ番号を囲むタグ（デフォルト値：設定無し）
'class'=>'',//上記タグのクラス名を設定（デフォルト値：設定無し）
'currentTag'=>'',//表示中のページ番号のタグを設定（デフォルト値：null）
'currentClass'=>'',//表示中のページ番号のクラスを設定（デフォルト値：current）
)
);
*/
	}


	public function menu_edit($menu_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

		if($this->request->data){
			if($this->request->data['submit'] == "更新"){
//debug($this->request->data);
//debug($this->request->data['MenuMSTR']);
				$menu = $this->request->data['MenuMSTR'];
				if (isset($menu['id'])){
					if($menu['id'] > 0){
						$menu_id = $menu['id'];
						$ret = $this->MenuMSTR->save($menu);
					}
  				}
			}
			$menu_id = $this->request->data['MenuMSTR']['id'];
			$cat1_no = $this->request->data['MenuMSTR']['cat1'];
			$cat2_no = $this->request->data['MenuMSTR']['cat2'];

			if(strstr($this->request->data['submit'], "アップロード")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
					$post = $this->request->data['Post']['image'];
					$tmp=$post['tmp_name'];
//debug($tmp);
					if(is_uploaded_file($tmp)) {

					}
				}
			}
		}
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}




	public function order(){
		$this->set('main_title', "注文管理(DT7)".$this->_server_name2);
		$error_msg = "";

		$conditions = $this->GetCartDT7OldRequestData();
		$targetTime = $this->EvaluateTime("close");
		//$conditions['Cart.checkin_time >'] = date('Y-m-d H:i:s', strtotime("+1 hour", $targetTime));		//06:00

		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'CartDT7Old' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('CartDT7Old.room_no', 'CartDT7Old.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('CartDT7Old');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
	}

	public function order_edit($order_id=0){
		$this->set('main_title', "注文管理(DT7)".$this->_server_name2);
		$error_msg = "";
//debug($this->request->data);

		if($this->request->data){
			$order = $this->request->data['CartDT7Old'];
			if(isset($order['id'])){
				$order_id = $order['id'];
				if(strstr($this->request->data['submit'], "更新")){
					if($order_id > 0){
//debug($save_array);
						$ret = $this->CartDT7Old->save($order);
					}
				}elseif(strstr($this->request->data['submit'], "削除")){
					$ret = $this->CartDT7Old->delete($order_id);
					$this->redirect(array('controller' => 'admin2', 'action' => 'order'));
				}
			}
		}
//debug($order_id);
		if($order_id > 0){
			$conditions = array('id'=>$order_id);
			$data = $this->CartDT7Old->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
//debug($conditions);
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function order2(){
		$this->set('main_title', "注文管理(ORD)".$this->_server_name2);
		$error_msg = "";

		$conditions = $this->GetCartORDOldRequestData();
		$targetTime = $this->EvaluateTime("close");
		//$conditions['CartORDOld.checkin_time >'] = date('Y-m-d H:i:s', strtotime("+1 hour", $targetTime));		//06:00

		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
//debug($conditions);
		$this->paginate = array(
			'CartORDOld' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('CartORDOld.room_no', 'CartORDOld.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('CartORDOld');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
	}

	public function order2_edit($order_id=0){
		$this->set('main_title', "注文管理(ORD)".$this->_server_name2);
		$error_msg = "";
//debug($this->request->data);

		if($this->request->data){
			$order = $this->request->data['CartORDOld'];
			if(isset($order['id'])){
				$order_id = $order['id'];
				if(strstr($this->request->data['submit'], "更新")){
					if($order_id > 0){
//debug($order);
						$ret = $this->CartORDOld->save($order);
					}
				}elseif(strstr($this->request->data['submit'], "削除")){
					$ret = $this->CartORDOld->delete($order_id);
					$this->redirect(array('controller' => 'admin2', 'action' => 'order2'));
				}
			}
		}
//debug($order_id);
		if($order_id > 0){
			$conditions = array('id'=>$order_id);
			$data = $this->CartORDOld->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
//debug($conditions);
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}




	
	public function store(){
		$this->set('main_title', "店舗管理".$this->_server_name2);
		$error_msg = "";
		$order_no = 1;
		
		$new_id = $this->Common->ResetModelID("Store");	//'
		$conditions = array();
//debug($this->request->data);
		if($this->request->data){
			$search = $this->request->data['Store'];
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$order_no = $search['order_no'];
					$conditions['Store.id'] = $order_no;
				}
			}

		}
		
		$this->paginate = array(
			'Store' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Store.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Store');
		$this->set('data', $data);

//'RoomGroup', 'RoomInfo', 
		//$order = array('id' => 'ASC');	//ASC | DESC
		//$conditions = array();
		$room_info = $this->RoomInfo->find('all');//, array('conditions' => $conditions, 'order' => $order)
		$this->set('room_info', $room_info);
//debug($room_group);

		$room_group = $this->RoomGroup->find('all');//, array('conditions' => $conditions, 'order' => $order)
		$this->set('room_group', $room_group);


		$this->set('error_msg', $error_msg);
	}

	public function store_edit($store_id=0){
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$store = $this->request->data['Store'];
//debug($store);
			if ($store['submit'] == "削除"){
				//$this->Store->delete($store['id']);
				$this->redirect(array('controller' => 'admin2', 'action' => 'store'));

			}elseif ($store['submit'] == "更新"){
				if($store['id'] > 0){
					$store_id = $store['id'];
//debug($store);
					$ret = $this->Store->save($store);
				}
				//$this->redirect(array('controller' => 'admin2', 'action' => 'store'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Store");	//'

		if($store_id > 0){
			$conditions = array('id'=>$store_id);
			$data = $this->Store->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


	public function store_new(){
		$error_msg = "";
		$order_no = 0;
		if($this->request->data){
//debug($this->request->data);
			$store = $this->request->data['Store'];
			if (isset($store['id'])){
				if($store['id'] > 0){
					$order_no = $store['id'];
					$save_array = array (
						'id'=>NULL, 'store_name'=>$store['store_name'],
						'open_time'=>$store['open_time'], 'close_time'=>$store['close_time'],
						//'page_pattern'=>$store['page_pattern'], 
						'max_room_no'=>$store['max_room_no'],
						'tel'=>$store['tel'], 'note1'=>$store['note1'], 'note2'=>$store['note2']);
//debug($save_array);
//exit();
					$ret = $this->Store->save($save_array);
				}
				$this->redirect(array('controller' => 'admin2', 'action' => 'store'));
				exit();
			}
		}
		$data['Store']['id'] = $this->Common->ResetModelID("Store");	//'
//debug($data['Store']['id']);

		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function store_edit2($info_id=0){
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$info = $this->request->data['RoomInfo'];
			if ($info['submit'] == "削除"){
				$this->RoomInfo->delete($info['id']);
				$this->redirect(array('controller' => 'admin2', 'action' => 'store'));

			}elseif ($info['submit'] == "更新"){
				if($info['id'] > 0){
					$info_id = $info['id'];
					$ret = $this->RoomInfo->save($info);
				}
				//$this->redirect(array('controller' => 'admin2', 'action' => 'store'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("RoomInfo");	//'

		if($info_id > 0){
			$conditions = array('id'=>$info_id);
			$data = $this->RoomInfo->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function store_edit3($group_id=0){
		$error_msg = "";
//debug($this->request->data);
		if($this->request->data){
			$group = $this->request->data['RoomGroup'];
			if ($group['submit'] == "削除"){
				$this->RoomGroup->delete($group['id']);
				$this->redirect(array('controller' => 'admin2', 'action' => 'store'));

			}elseif ($group['submit'] == "更新"){
				if($group['id'] > 0){
					$group_id = $group['id'];
					$ret = $this->RoomGroup->save($group);
				}
				//$this->redirect(array('controller' => 'admin2', 'action' => 'store'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("RoomGroup");	//'

		if($group_id > 0){
			$conditions = array('id'=>$group_id);
			$data = $this->RoomGroup->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}



	private function EvaluateTime($mode="close"){
		$open_time = $this->Store->field("open_time", array('id'=>$this->_order_no));
		$close_time = $this->Store->field("close_time", array('id'=>$this->_order_no));
		if($mode=="open")
			$targetTime = strtotime(date("Y-m-d ".$open_time));
		else
			$targetTime = strtotime(date("Y-m-d ".$close_time));

		$time1 = new DateTime(date("H:i:s"));
		$time2 = new DateTime('00:00:00');
		$time3 = new DateTime($close_time);
		if(($time1 > $time2) and ($time1 < $time3))
			$targetTime = strtotime("-1 day", $targetTime);
		return $targetTime;
	}



//	http://localhost/psp/admin2/export_excel
//  http://s.piearson.shop/psp/admin2/export_excel
	public function export_excel($model=''){
		//$this->autoRender = false;	//View File なし
		if($model == "MenuMSTR")
			$outputFile = "_menus.xlsx";
		elseif($model == "Cart")
			$outputFile = "_carts.xlsx";
		else{
			debug("Error");
			exit();
		}
			
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'psp'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		
		if($model == "MenuMSTR"){
			$fields = array();
			$conditions = array('order_no'=>$this->_order_no);
			$group = array();
			$orders = array('id');
			$data = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
			//$items = array('id','order_no','cat1','cat1_no','cat2','cat2_no','category3','cat3_no','menu_name','unit_price','photo_no','not_use');
			$items = array('id','店舗id','カテゴリ1','cat1_no','カテゴリ2','cat2_no','カテゴリ3','cat3_no','商品名','単価','写真ファイル','未使用');
		}elseif($model == "Cart"){
//debug($this->_menu_id);
//exit();
			$conditions = $this->GetCartRequestData();

			$fields = array();
			//$conditions = array('order_no'=>$this->_order_no);
			$group = array();
			$orders = array('id');
			$data = $this->Cart->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
			$items = array('id','受付id','店舗id','部屋番号','テーブル番号','メニューid','メニュー名','単価','数量','金額','税金','合計',
				'注文済','注文時間','配膳済','配膳時間','催促');
		}

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

	public function import_excel(){
		$this->autoRender = false;	//View File なし
		if ($this->request->data){
//debug($this->request->data);
			$post = $this->request->data['Post']['image'];
			$tmp=$post['tmp_name'];
//debug($tmp);
			if(is_uploaded_file($tmp)) {
				$file_name = basename($post['name']);
				$file = WWW_ROOT.'files'.DS.'psp'.DS.$file_name;
//debug($file);
//exit();
				if (move_uploaded_file($tmp, $file)) {
					$this->ReadExcel($file);
				}else{
					debug("Upload Error");
					$error_msg = "Upload Error";
				}
			}
		}
	
	}

	private function ReadExcel($file){
//debug($file);
		$reader = PHPExcel_IOFactory::createReader('Excel2007');
		// 読み込む
		$excel = $reader->load($file);
		// D:\xampp\htdocs\psp\app\Vendor\phpexcel\PHPExcel\CellDefaultValueBinder.php変更

		// 最初のシートを取得
		$sheet = $excel->getActiveSheet();
		$rows = 0;
		$i = 0;
		// 行
		foreach ($sheet->getRowIterator() as $row){
			if($rows++ > 0){
				$items = array('id','order_no','cat1','cat1_no','cat2','cat2_no','category3','cat3_no','menu_name','unit_price','photo_no','not_use');
				$j = 0;
				// セル
				foreach ($row->getCellIterator() as $cell){
				    // 各セルの値を取得
					$data[$i]['MenuMSTR'][$items[$j++]] = $cell->getValue();
//debug($cell->getValue());
//debug($data);
//exit();
				}
				$i++;
//debug($data);
//exit();
		  	}
		}
		//テーブル内容消去
		$this->MenuMSTR->truncate();
//debug($data);
		$this->MenuMSTR->saveAll($data);
//debug("OK");
		$this->redirect(array('controller' => 'admin2', 'action' => 'menu'));
exit();
	}

	private function GetMenuRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['MenuMSTR'];
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$this->_order_no = $search['order_no'];
					$conditions['MenuMSTR.order_no'] = $this->_order_no;
				}
			}
			if (isset($search['menu_id'])){
				if($search['menu_id'] > 0){
					$this->_menu_id = $search['menu_id'];
					$conditions['MenuMSTR.id'] = $this->_menu_id;
				}
			}
			if (isset($search['cat1'])){
				if($search['cat1']){
					$this->_cat1 = $search['cat1'];
					$conditions['MenuMSTR.cat1 like'] = $this->_cat1;
				}
			}
			if (isset($search['cat2'])){
				if($search['cat2']){
					$this->_cat2 = $search['cat2'];
					$conditions['MenuMSTR.cat2 like'] = $this->_cat2;
				}
			}
			if (isset($search['menu_name'])){
				if($search['menu_name']){
					$this->_menu_name = $search['menu_name'];
					$conditions['MenuMSTR.menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}
			if (isset($search['photo_no'])){
				if($search['photo_no']){
					$this->_photo_no = $search['photo_no'];
					$conditions['MenuMSTR.photo_no like'] = '%'.$this->_photo_no.'%';
				}
			}
		}
		$this->set('order_no', $this->_order_no);
		$this->set('menu_id', $this->_menu_id);
		$this->set('menu_name', $this->_menu_name);
		$this->set('cat1', $this->_cat1);
		$this->set('cat2', $this->_cat2);
		$this->set('photo_no', $this->_photo_no);
//debug($conditions);
		return $conditions;
	}

	private function GetBumonRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['Bumon'];
			if (isset($search['bumon_id'])){
				if($search['bumon_id'] > 0){
					$this->_bumon_id = $search['bumon_id'];
					$conditions['Bumon.id'] = $this->_bumon_id;
				}
			}
			if (isset($search['cat1'])){
				if($search['cat1']){
					$this->_cat1 = $search['cat1'];
					$conditions['Bumon.cat1 like'] = $this->_cat1;
				}
			}
			if (isset($search['cat2'])){
				if($search['cat2']){
					$this->_cat2 = $search['cat2'];
					$conditions['Bumon.cat2 like'] = $this->_cat2;
				}
			}
			if (isset($search['cat2name'])){
				if($search['cat2name']){
					$this->_cat2name = $search['cat2name'];
					$conditions['Bumon.cat2name like'] = '%'.$this->_cat2name.'%';
				}
			}
			if (isset($search['cat2flag'])){
				if($search['cat2flag']){
					$this->_cat2flag = $search['cat2flag'];
					$conditions['Bumon.cat2flag like'] = '%'.$this->_cat2flag.'%';
				}
			}
		}
		$this->set('bumon_id', $this->_bumon_id);
		$this->set('cat2name', $this->_cat2name);
		$this->set('cat1', $this->_cat1);
		$this->set('cat2', $this->_cat2);
		$this->set('cat2flag', $this->_cat2flag);
//debug($conditions);
		return $conditions;
	}


	private function GetCartDT7OldRequestData(){
		$conditions = array();
		$conditions['room_no >'] = 0;
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['CartDT7Old'];
//debug($search);

			if (isset($search['cart_id'])){
				if($search['cart_id'] > 0){
					$this->_cart_id = $search['cart_id'];
					$conditions['id'] = $this->_cart_id;
				}
			}
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$this->_order_no = $search['order_no'];
					$conditions['order_no'] = $this->_order_no;
				}
			}
			if (isset($search['room_no'])){
				if($search['room_no'] > 0){
					$this->_room_no = $search['room_no'];
					$conditions['room_no'] = $this->_room_no;
				}
			}

			if (isset($search['menu_name'])){
				if($search['menu_name'] != ""){
//debug($search);
					$this->_menu_name = $search['menu_name'];
					$conditions['menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}

		}
		$this->set('cart_id', $this->_cart_id);
		$this->set('order_no', $this->_order_no);
		$this->set('room_no', $this->_room_no);
		
		$this->set('menu_name', $this->_menu_name);
//debug($conditions);
		return $conditions;
	}

	private function array_to_string($arr){
		$s = "";
//debug($arr);
		foreach ($arr as $key => $value)
			$s .= "/".$key.":".$value;
		return $s;
	}

	private function GetCartORDOldRequestData(){
		$conditions = array();
		$conditions['room_no >'] = 0;
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['CartORDOld'];
//debug($search);

			if (isset($search['cart_id'])){
				if($search['cart_id'] > 0){
					$this->_cart_id = $search['cart_id'];
					$conditions['id'] = $this->_cart_id;
				}
			}
			if (isset($search['order_no'])){
				if($search['order_no'] > 0){
					$this->_order_no = $search['order_no'];
					$conditions['order_no'] = $this->_order_no;
				}
			}
			if (isset($search['room_no'])){
				if($search['room_no'] > 0){
					$this->_room_no = $search['room_no'];
					$conditions['room_no'] = $this->_room_no;
				}
			}

			if (isset($search['menu_name'])){
				if($search['menu_name'] != ""){
//debug($search);
					$this->_menu_name = $search['menu_name'];
					$conditions['menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}

			if (isset($search['order_no'])){
				if($search['order_no'] != ""){
//debug($search);
					$this->_order_no = $search['order_no'];
					$conditions['order_no'] = $this->_order_no;
				}
			}
			if (isset($search['order_send'])){
				if($search['order_send'] != ""){
//debug($search);
					$this->_order_send = $search['order_send'];
					$conditions['order_send'] = $this->_order_send;
				}
			}

		}
		$this->set('cart_id', $this->_cart_id);
		$this->set('room_no', $this->_room_no);
		$this->set('order_no', $this->_order_no);
		$this->set('order_send', $this->_order_send);
		
		$this->set('menu_name', $this->_menu_name);
//debug($conditions);
		return $conditions;
	}


















	private function GetStore(){
		$store = $this->Store->find('first', array('conditions' => array('Store.id' => $this->_order_no)));
		//if (! $this->data){ throw new NotFoundException(); }
		if(!$store){ echo "エラーGetStore"; debug("Error!!!"); }
//debug($store);
		$this->_order_no = $store['Store']['id'];
		$this->set('_order_no', $this->_order_no);

		$this->_store_name = $store['Store']['store_name'];
		$this->set('_store_name', $this->_store_name);

		//$this->_page_pattern = $store['Store']['page_pattern'];
		//$this->set('_page_pattern', $this->_page_pattern);

		//$_max_room_no = $store['Store']['max_room_no'];
		//$this->set('_max_room_no', $this->_max_room_no);

		$this->set('store', $store);
	}

	public function show_constants(){
		debug(APP);
		debug(APP_DIR);
		debug(APPLIBS);
		debug(CACHE);
		debug(CAKE);
		debug(CAKE_CORE_INCLUDE_PATH);
		debug(CORE_PATH);
		debug(CSS);
		debug(CSS_URL);
		debug(DS);
		debug(FULL_BASE_URL);
		debug(IMAGES);
		debug(IMAGES_URL);
		debug(JS);
		debug(JS_URL);
		debug(LOGS);
		debug(ROOT);
		debug(TESTS);
		debug(TMP);
		debug(VENDORS);
		debug(WEBROOT_DIR);
		debug(WWW_ROOT);
		debug();
		debug(TIME_START);
	}











	public function get_pos_data(){
//debug($this->_server_name2);
		$path = $this->Common->GetRoomrdPath();
//debug($path);
		$dir = new Folder($path);
    	$files = $dir->read();
//debug($files);
		for($i=0; $i<count($files[1]); $i++){
			$this->read_file($path.$files[1][$i]);
		}
exit();
		
	}
	
	private function read_file($path_file){
		$file_info = pathinfo($path_file);
		$ext = $file_info['extension'];
		$filename = $file_info['filename'];
		$room_no = (int)substr($filename, 2);
debug($room_no);

		$file = new File($path_file);
	    $contents = $file->read();
		$contents = str_replace('\n', '', $contents);
debug($contents);
		if($ext == "DT1"){	//S2 00089 0456 02 00 0000 0
			$over_flag = (int)substr($contents, 1, 1);	//2 or 3 超過0分から
			$leave_remain_time = (int)substr($contents, 2, 5);	//退出残り時間（分単位）
			$entry_close_time = (int)substr($contents, 7, 4);	//入室時から閉店までの時間（分単位）
			$people = (int)substr($contents, 11, 2);	//入数
			$drink_free = (int)substr($contents, 14, 1);	//飲み放題種類
			$drink_free_time = (int)substr($contents, 15, 4);	//飲み放題残り時間
echo $over_flag."/".$leave_remain_time."/".$entry_close_time."/".$people."/".$drink_free."/".$drink_free_time."/";			
		}elseif($ext == "DT4" and strstr($contents, "S0")){
			$checkout = 2;
		}elseif($ext == "DT7"){	//R 001678 00174 002  [0004 02 00516]  [0005 01 00472]
			$total = (int)substr($contents, 1, 6);	//料金合計
			$room_charge = (int)substr($contents, 7, 5);	//室料
			$products = (int)substr($contents, 12, 3);	//商品明細点数

			$order_no = "";
			$qty = "";
			$price = "";
			$m = 15;
			$n = 19;
			$l = 21;
			for($i=0; $i<$products; $i++){
				if($i <> 0){
					$order_no .= "|";
					$qty .= "|";
					$price .= "|";
				}
				$order_no .= (int)substr($contents, $m, 4);	//オーダーNO
				$qty .= (int)substr($contents, $n, 2);	//数量
				$price .= (int)substr($contents, $l, 5);	//金額
				$n += 11;
				$m += 11;
				$l += 11;
			}
echo $total."/".$room_charge."/".$products."/".$order_no."/".$qty."/".$price;			
		
exit();		
		}
	}
	

}
